--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNmrFinalGather ""
(
  ---SECTION 1 - LOCAL VARIABLES---
  local LOCfgPresetFile
  local LOCfgCustomName = DYNuiResourcesLabels[246]

  ---SECTION 2 - LOCAL FUNCTIONS---
  fn DYNFUNdisplayFGControls FUNswitch =
  (
    for i in DYNmrFinalGather.controls do i.enabled = FUNswitch
    DYNmrFinalGather.CBDYNonOff.enabled = if classOf renderers.production == mental_ray_renderer then true else false
  )

  fn DYNFUNdisplayFinalGatherParams =
  (
    --- Test Specifically for Mental Ray Here, not Quicksilver or iRay
    if classOf renderers.production == mental_ray_renderer then
    (
      --- Get INI File Settings
      /*
        .FinalGatherEnable2 : boolean
        .UseFinalGatherFile : boolean
        .FinalGatherFreeze : boolean
        .FinalGatherPreview : boolean
        .FinalGatherFalloff : boolean
        .FinalGatherUseRadiusInterpolation : boolean
        .UseFinalGatherRadius : boolean
        .UseFinalGatherMinRadius : boolean
        .FinalGatherView : boolean
        .FinalGatherAccuracy : integer
      .FinalGatherInterpolationSamples : integer
      .FinalGatherDensity : float
        .FinalGatherFilter : integer
        .FinalGatherTraceDepth : integer
        .FinalGatherReflectionDepth : integer
        .FinalGatherRefractionDepth : integer
        .FinalGatherBounces : integer
        .FinalGatherBounceMultiplier : float
        .FinalGatherFalloffStart : float
        .FinalGatherFalloffStop : float
        .FinalGatherRadius : float
        .FinalGatherRadius_View : float
        .FinalGatherMinRadius : float
        .FinalGatherMinRadius_View : float
        .FGMultiplierScalar : float
        .FGMultiplierColor : color
        .FinalGatherFilename : string
      */
      local LOCarray = getINIsetting DYNmrFinalGather.LOCfgPresetFile
      if LOCarray.count > 0 then
      (
        --- #("Draft", "Low", "Medium", "High", "Very High")
        append LOCarray DYNmrFinalGather.LOCfgCustomName
        DYNmrFinalGather.DDDYNdefaults.items     = LOCarray
        DYNmrFinalGather.DDDYNdefaults.selection = LOCarray.count
        DYNmrFinalGather.DYNFUNfinalGatherPreset DYNmrFinalGather.DDDYNdefaults.selected
        DYNmrFinalGather.CBDYNonOff.checked      = renderers.production.FinalGatherEnable2
        DYNmrFinalGather.SPDYNmultiplier.value   = renderers.production.FGMultiplierScalar
        DYNmrFinalGather.CODYNmultiplier.color   = renderers.production.FGMultiplierColor
        DYNmrFinalGather.SPDYNbounces.value      = renderers.production.FinalGatherBounces
        DYNmrFinalGather.SPDYNweight.value       = renderers.production.FinalGatherBounceMultiplier
      )
      DYNmrFinalGather.DYNFUNdisplayFGControls DYNmrFinalGather.CBDYNonOff.checked
    )
    else
    (
      DYNmrFinalGather.DYNFUNdisplayFGControls false
    )
  )

  fn DYNFUNfinalGatherPreset FUNpreset =
  (
    if FUNpreset != DYNmrFinalGather.LOCfgCustomName then
    (
      local LOCdensity       = getINIsetting DYNmrFinalGather.LOCfgPresetFile FUNpreset "Density"
      local LOCraysPerPoint  = getINIsetting DYNmrFinalGather.LOCfgPresetFile FUNpreset "RaysPerPoint"
      local LOCinterpSamples = getINIsetting DYNmrFinalGather.LOCfgPresetFile FUNpreset "InterpolationSamples"

      LOCdensity       = if LOCdensity       != "" then (if LOCdensity       as float   != undefined then LOCdensity       as float   else 0.1) else 0.1
      LOCraysPerPoint  = if LOCraysPerPoint  != "" then (if LOCraysPerPoint  as integer != undefined then LOCraysPerPoint  as integer else 50)  else 50
      LOCinterpSamples = if LOCinterpSamples != "" then (if LOCinterpSamples as integer != undefined then LOCinterpSamples as integer else 30)  else 30

      renderers.production.FinalGatherDensity   = LOCdensity
      renderers.production.finalGatherAccuracy  = LOCraysPerPoint
      renderers.production.FinalGatherInterpolationSamples = LOCinterpSamples

      DYNmrFinalGather.SPDYNdensity.value       = LOCdensity
      DYNmrFinalGather.SPDYNraysPerPoint.value  = LOCraysPerPoint
      DYNmrFinalGather.SPDYNinterpSamples.value = LOCinterpSamples
    )
    else
    (
      DYNmrFinalGather.SPDYNdensity.value       = renderers.production.FinalGatherDensity
      DYNmrFinalGather.SPDYNraysPerPoint.value  = renderers.production.finalGatherAccuracy
      DYNmrFinalGather.SPDYNinterpSamples.value = renderers.production.FinalGatherInterpolationSamples
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  checkbox CBDYNonOff pos:[4,9] width:180 align:#left

  groupbox GBDYNgroup01      pos:[4,27]  width:(DYNiniExplorerWidth - 21) height:50
  dropdownlist DDDYNdefaults "" width:(DYNiniExplorerWidth - 38) pos:[13,47]

  groupbox GBDYNgroup02      pos:[4,84]  width:(DYNiniExplorerWidth - 21) height:166
  label LBDYNmultiplier      pos:[13,110] width:80
  spinner SPDYNmultiplier    pos:[(DYNiniExplorerWidth - 96),107] fieldwidth:60 range:[0.0,999999995904.0,0.0] scale:0.1
  colorpicker CODYNmultiplier pos:[(DYNiniExplorerWidth - 115),107] width:19 height:16

  label LBDYNdensity         pos:[13,137] width:105
  label LBDYNraysPerPoint    pos:[13,158] width:105
  label LBDYNinterpSamples   pos:[13,179] width:105
  spinner SPDYNdensity       pos:[(DYNiniExplorerWidth - 96),134] fieldwidth:60 range:[0.0,100.0,0.0] scale:0.1
  spinner SPDYNraysPerPoint  pos:[(DYNiniExplorerWidth - 96),155] fieldwidth:60 range:[1,100000000,1] type:#integer
  spinner SPDYNinterpSamples pos:[(DYNiniExplorerWidth - 96),176] fieldwidth:60 range:[1,1000,1] type:#integer

  label LBDYNbounces         pos:[13,206] width:105
  label LBDYNweight          pos:[13,227] width:105
  spinner SPDYNbounces       pos:[(DYNiniExplorerWidth - 96),203] fieldwidth:60 range:[0,100000000,0] type:#integer
  spinner SPDYNweight        pos:[(DYNiniExplorerWidth - 96),224] fieldwidth:60 range:[0.0,1.0,0.0] type:#float scale:0.1

  button BUDYNreset width:(DYNiniExplorerWidth - 23) pos:[4,259]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNmrFinalGather open do
  (
    DYNmrFinalGather.title  = DYNuiRolloutNames[27]

    GBDYNgroup01.text       = DYNuiResourcesGroups[77]
    GBDYNgroup02.text       = DYNuiResourcesGroups[78]

    LBDYNmultiplier.text    = DYNuiResourcesLabels[131]
    LBDYNdensity.text       = DYNuiResourcesLabels[247]
    LBDYNraysPerPoint.text  = DYNuiResourcesLabels[248]
    LBDYNinterpSamples.text = DYNuiResourcesLabels[249]
    LBDYNbounces.text       = DYNuiResourcesLabels[250]
    LBDYNweight.text        = DYNuiResourcesLabels[251]

    CBDYNonOff.text         = DYNuiResourcesButtons[59]
    BUDYNreset.text         = DYNuiResourcesButtons[13]

    LOCfgPresetFile         = (getDir #plugcfg) + "\\mentalray_fg_presets.ini"

    DYNFUNdisplayFinalGatherParams()
  )

  on DYNmrFinalGather close do
  (
    LOCfgPresetFile = undefined
    LOCfgCustomName = undefined
  )

  on DDDYNdefaults     selected arg do (try (DYNFUNfinalGatherPreset DDDYNdefaults.selected)   catch (DYNFUNdisplayFGControls false))
  on SPDYNmultiplier    changed arg do (try (renderers.production.FGMultiplierScalar   = arg)  catch (DYNFUNdisplayFGControls false))
  on CODYNmultiplier    changed arg do (try (renderers.production.FGMultiplierColor    = arg)  catch (DYNFUNdisplayFGControls false))
  on SPDYNdensity       changed arg do (try (renderers.production.FinalGatherDensity   = arg)  catch (DYNFUNdisplayFGControls false))
  on SPDYNraysPerPoint  changed arg do (try (renderers.production.finalGatherAccuracy  = arg)  catch (DYNFUNdisplayFGControls false))
  on SPDYNinterpSamples changed arg do (try (renderers.production.FinalGatherInterpolationSamples = arg)  catch (DYNFUNdisplayFGControls false))
  on SPDYNbounces       changed arg do (try (renderers.production.FinalGatherBounces   = arg)  catch (DYNFUNdisplayFGControls false))
  on SPDYNweight        changed arg do (try (renderers.production.FinalGatherBounceMultiplier = arg)  catch (DYNFUNdisplayFGControls false))
  on CBDYNonoff         changed arg do
  (
    try
    (
      renderers.production.FinalGatherEnable2 = arg
      DYNFUNdisplayFinalGatherParams()
    )
    catch
    (
      DYNFUNdisplayFGControls false
    )
    DYNamite.dnIndirectNode.forecolor = DYNFUNdnColor (if not arg then DYNINIgreyedOutColor else (((colorMan.getColor #text) as color) * 255))
  )

  on BUDYNreset pressed do
  (
    renderers.production.FinalGatherDensity   = 0.1
    renderers.production.finalGatherAccuracy  = 50
    renderers.production.FinalGatherInterpolationSamples = 30
    renderers.production.FGMultiplierScalar   = 1.0
    renderers.production.FGMultiplierColor    = color 255 255 255
    renderers.production.FinalGatherBounces   = 0
    renderers.production.FinalGatherBounceMultiplier = 1.0
    DYNFUNdisplayFinalGatherParams()
  )
)
